% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/work_test_norm_global.R
\name{sample_size_norm_global}
\alias{sample_size_norm_global}
\title{Calculate sample size or power for a globally efficient adaptive design.}
\usage{
sample_size_norm_global(
  initial_test = 0,
  sample_size = TRUE,
  effect_size = 0,
  time = 0,
  target_power = 0.8,
  final_time = 0,
  tol_sample_size = 1e-05,
  input_check = TRUE
)
}
\arguments{
\item{initial_test}{Designate the initial working test generated by \code{\link{work_test_norm_global}} function.}

\item{sample_size}{If \code{TRUE}, the function will return the sample size required by the globally efficient adaptive design to have the power of \code{target_power}. If \code{FALSE}, the function will return the power when the final interim analysis and the final analysis are conducted at \code{time} and \code{final_time}, respectively.}

\item{effect_size}{The effect size, on the basis of which the power or sample size calculation will be performed. In globally efficient designs, any real value is allowed.}

\item{time}{The time of the current analysis.}

\item{target_power}{The power, on the basis of which the sample size calculation will be performed.}

\item{final_time}{The time of the final analysis.}

\item{tol_sample_size}{The precision in calculation of the sample size.}

\item{input_check}{Indicate whether or not the arguments input by user contain invalid values.}
}
\value{
It returns the sample size (when \code{sample_size = TRUE}) or the power (when \code{sample_size = FALSE}).
}
\description{
\code{sample_size_norm_global} calculates the power if the time of the final
analysis is given and otherwise the sample size.
The computed power for \code{effect_size} is an approximate lower bound.
Sample size is also calculated on the basis of the bound.
}
\seealso{
\code{\link{adaptive_analysis_norm_global}} for example of this function.
}
