% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{daniel_plot_hn}
\alias{daniel_plot_hn}
\title{Daniel's plot (half-normal)}
\usage{
daniel_plot_hn(model, label_n = 6, line.p = c(0, 0.4), ...)
}
\arguments{
\item{model}{a linear model}

\item{label_n}{plot the labels of the highest n values}

\item{line.p}{vector of quantiles to use when fitting the Q-Q line, defaults
defaults to 0.25 that corresponds to c(0.25, 0.75) on the full set of
quantiles. If you pass a vector of two elements (first MUST be 0), then the
line is fitted through the origin and up to 1 minus the second element quantile}

\item{...}{further arguments to \code{\link[gghalfnorm:gghalfnorm]{gghalfnorm::gghalfnorm()}}}
}
\value{
a half-normal plot (GGPlot2 object) with the effects of the model
}
\description{
Given a non-replicated model of a factorial plan, this function provides a
half-normal plot of the effects of the model, labeling the main n effects.
}
\examples{
daniel_plot_hn(lm(Y~A*B*C*D, data=filtration))
}
\seealso{
\code{\link[gghalfnorm:gghalfnorm]{gghalfnorm::gghalfnorm()}}
}
