% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_operators.R
\name{apply_labels}
\alias{apply_labels}
\title{Apply Labels to a dataset}
\usage{
apply_labels(data, labels_df = metadata_nca_variables, type = "ADNCA")
}
\arguments{
\item{data}{The dataset to which labels will be applied.}

\item{labels_df}{A data frame containing at least the columns "Variable", "Label", and "Dataset".}

\item{type}{The type variable in labels_df for which the labels are to be applied.}
}
\value{
The same dataset with label attributes applied to all columns.
If a column is not present in the labels list, it will be assigned the name of the col.
If label already exists in the original data, it will be preserved.
}
\description{
This function adds "label" attributes to all columns in a dataset
}
\examples{
 data <- data.frame(USUBJID = c(1, 2, 3), AVAL = c(4, 5, 6))
 labels <- data.frame(
   Variable = c("USUBJID", "AVAL"),
   Label = c("Unique Subject Identifier", "Analysis Value"),
   Dataset = c("ADNCA", "ADNCA")
 )
 data <- apply_labels(data, labels, "ADNCA")
 print(attr(data$USUBJID, "label")) # "Unique Subject Identifier"
 print(attr(data$AVAL, "label"))    # "Analysis Value"

}
