% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay_discounting_fit.R
\name{eq_hyp}
\alias{eq_hyp}
\title{Hyperbolic function}
\usage{
eq_hyp(k, delay)
}
\arguments{
\item{k}{numeric constant, the delay discounting parameter}

\item{delay}{vector of delays}
}
\value{
A numeric vector of subjective values between 0 and 1
}
\description{
An hyperbolic function to simulate delay discounting data
}
\examples{
delay <- seq(0, 10, len = 100)
k <- 0.2
sv <- eq_hyp(k, delay)
plot(delay, sv,
  xlab = "delay",
  ylab = "Sv",
  type = "l"
)
}
