% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curv_indexes.R
\name{curv_index_fry}
\alias{curv_index_fry}
\title{Curvature index using Fry derivation}
\usage{
curv_index_fry(cr, time_in, fi_val, n = 4)
}
\arguments{
\item{cr}{A numeric vector of cumulative response}

\item{time_in}{numeric, time (or the x axis in a cumulative response plot)}

\item{fi_val}{the FI value}

\item{n}{numeric, the number of subintervals}
}
\value{
The curvature index as exposed by Fry
}
\description{
Curvature index using Fry derivation
}
\examples{
data("r_times")
r_times <- r_times[r_times < 60]
cr <- seq_along(r_times)

plot(r_times, cr, type = "s", xlim = c(min(r_times), max(r_times)))
segments(
  x0 = min(r_times), y0 = min(cr),
  x1 = max(r_times), y1 = max(cr)
)
segments(
  x0 = min(r_times) + (max(r_times) - min(r_times)) / 2, y0 = min(cr),
  x1 = max(r_times), y1 = max(cr),
  col = "red"
)
curv_index_fry(cr, r_times, 60, 4)
}
