## ----echo = FALSE-------------------------------------------------------------
library(YEAB)

## -----------------------------------------------------------------------------
data("r_times")

head(r_times, n = 30)

## -----------------------------------------------------------------------------
bins <- get_bins(r_times, 0, 180, 2) # Binarize r_times to create a response rate distribution of 2 sec. bins.

bin_res <- 6
response_rate <- f_table(bins, 0, 180, bin_res)
res_rate_norm <- response_rate$prop / max(response_rate$prop) # Normalize the response rate values.
bins <- response_rate$bins # Get the time bins vector.

## -----------------------------------------------------------------------------
balci_ind <- balci2019(res_rate_norm, bins)

balci_ind$params

## ----echo = FALSE-------------------------------------------------------------
plot(bins, res_rate_norm, xlab = "6 sec. Bins", ylab = "Normalized Response Rate")
lines(bins, balci_ind$mov_av, col = "blue", lwd = 2)
abline(v = balci_ind$params[c(1, 2, 4)], lwd = c(1, 1, 2), col = c(1, 1, "red4"))

