% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{vcov.WH_2d}
\alias{vcov.WH_2d}
\title{Compute variance-covariance matrix of fitted 1D WH model}
\usage{
\method{vcov}{WH_2d}(object, pred = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{"WH_2d"} returned by the \code{\link[=WH]{WH()}} function}

\item{pred}{Should the variance-covariance matrix include the extrapolated
values as well (if any) ?}

\item{...}{Not used}
}
\value{
The variance-covariance matrix for the fitted values
}
\description{
The variance-covariance matrix may be useful in case confidence intervals are
required for quantities derived from the fitted values.
}
\examples{

object <- WH(portfolio_LTC$d, portfolio_LTC$ec)
V <- vcov(object)

object_extra <- predict(object, newdata = list(age = 60:109, duration = 0:19))
V <- vcov(object_extra)

}
