% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_plot.R
\name{ggplot.visitation_model}
\alias{ggplot.visitation_model}
\title{visitation_model ggplot2 method}
\usage{
\method{ggplot}{visitation_model}(
  data,
  mapping = aes(),
  difference = TRUE,
  actual_visitation = NULL,
  predicted_visitation_label = "Predicted",
  actual_visitation_label = "Actual",
  xlab = "Time",
  ylab = "Fitted Value",
  pred_color = "#ff6361",
  actual_color = "#ffa600",
  size = 1.5,
  main = "Fitted values for visitation model",
  plot_points = FALSE,
  date_breaks = "1 year",
  date_labels = "\%y \%b",
  ...
)
}
\arguments{
\item{data}{An object of class "decomposition".}

\item{mapping}{Default list of aesthetic mappings to use for plot. If not specified, must be supplied in each layer added to the plot.}

\item{difference}{A Boolean specifying whether to plot the original fit or differenced series. The default option is TRUE, in which case, the series is differenced.}

\item{actual_visitation}{A timeseries object representing the actual visitation that will be plotted along site the visitation_forecast object.}

\item{predicted_visitation_label}{a string that will be used for the label of the actual visitation.}

\item{actual_visitation_label}{a string that will be used for the label of the actual visitation.}

\item{xlab}{A string that will be used for the xlabel of the plot}

\item{ylab}{A string that will be used for the ylabel of the plot}

\item{pred_color}{a string that will be used for the predicted series color of the plot,}

\item{actual_color}{a String that will be used for the actual series color of the plot,}

\item{size}{A number that represents the thickness of the lines being plotted}

\item{main}{A string that will be used for the title of the plot}

\item{plot_points}{a boolean to specify if the plot should be points or continous line.}

\item{date_breaks}{A string to represent the distance between dates that the x-axis should be in. ex "1 month", "1 year"}

\item{date_labels}{A string to represent the format of the x-axis time labels.}

\item{...}{Additional arguments.}
}
\value{
No return value, called for plotting objects of the class "visitation_forecast".
}
\description{
Methods for plotting objects of the class "decomposition" with ggplot2.
}
