% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embedders.R
\name{LateInteractionEmbedder}
\alias{LateInteractionEmbedder}
\title{Late Interaction Embedder (Simplified ColBERT-style)}
\description{
Token-level embeddings for late interaction scoring
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{dimension}}{Token embedding dimension}

\item{\code{language}}{Language setting ("en" or "ml")}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LateInteractionEmbedder-new}{\code{LateInteractionEmbedder$new()}}
\item \href{#method-LateInteractionEmbedder-embed}{\code{LateInteractionEmbedder$embed()}}
\item \href{#method-LateInteractionEmbedder-score}{\code{LateInteractionEmbedder$score()}}
\item \href{#method-LateInteractionEmbedder-clone}{\code{LateInteractionEmbedder$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LateInteractionEmbedder-new"></a>}}
\if{latex}{\out{\hypertarget{method-LateInteractionEmbedder-new}{}}}
\subsection{Method \code{new()}}{
Create a new LateInteractionEmbedder
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LateInteractionEmbedder$new(dimension = 64, language = "en")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dimension}}{Embedding dimension per token}

\item{\code{language}}{Language behavior ("en" = ASCII-focused, "ml" = Unicode-aware)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LateInteractionEmbedder-embed"></a>}}
\if{latex}{\out{\hypertarget{method-LateInteractionEmbedder-embed}{}}}
\subsection{Method \code{embed()}}{
Embed texts to token-level embeddings
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LateInteractionEmbedder$embed(texts)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{texts}}{Character vector of texts}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of matrices (each matrix is token embeddings for a document)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LateInteractionEmbedder-score"></a>}}
\if{latex}{\out{\hypertarget{method-LateInteractionEmbedder-score}{}}}
\subsection{Method \code{score()}}{
Compute late interaction (MaxSim) score
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LateInteractionEmbedder$score(query_embeddings, doc_embeddings)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query_embeddings}}{Query token embeddings matrix}

\item{\code{doc_embeddings}}{Document token embeddings matrix}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Numeric score
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LateInteractionEmbedder-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LateInteractionEmbedder-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LateInteractionEmbedder$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
