% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{Filter}
\alias{Filter}
\title{Filter Class for Metadata Filtering}
\description{
Build metadata filters for search queries
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{conditions}}{List of filter conditions}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Filter-new}{\code{Filter$new()}}
\item \href{#method-Filter-eq}{\code{Filter$eq()}}
\item \href{#method-Filter-ne}{\code{Filter$ne()}}
\item \href{#method-Filter-gt}{\code{Filter$gt()}}
\item \href{#method-Filter-lt}{\code{Filter$lt()}}
\item \href{#method-Filter-in_list}{\code{Filter$in_list()}}
\item \href{#method-Filter-to_list}{\code{Filter$to_list()}}
\item \href{#method-Filter-clone}{\code{Filter$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Filter-new"></a>}}
\if{latex}{\out{\hypertarget{method-Filter-new}{}}}
\subsection{Method \code{new()}}{
Create a new Filter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Filter$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Named filter conditions}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Filter-eq"></a>}}
\if{latex}{\out{\hypertarget{method-Filter-eq}{}}}
\subsection{Method \code{eq()}}{
Add equality condition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Filter$eq(field, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{Field name}

\item{\code{value}}{Value to match}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Filter-ne"></a>}}
\if{latex}{\out{\hypertarget{method-Filter-ne}{}}}
\subsection{Method \code{ne()}}{
Add not-equal condition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Filter$ne(field, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{Field name}

\item{\code{value}}{Value to exclude}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Filter-gt"></a>}}
\if{latex}{\out{\hypertarget{method-Filter-gt}{}}}
\subsection{Method \code{gt()}}{
Add greater-than condition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Filter$gt(field, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{Field name}

\item{\code{value}}{Threshold value}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Filter-lt"></a>}}
\if{latex}{\out{\hypertarget{method-Filter-lt}{}}}
\subsection{Method \code{lt()}}{
Add less-than condition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Filter$lt(field, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{Field name}

\item{\code{value}}{Threshold value}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Filter-in_list"></a>}}
\if{latex}{\out{\hypertarget{method-Filter-in_list}{}}}
\subsection{Method \code{in_list()}}{
Add in-list condition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Filter$in_list(field, values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{Field name}

\item{\code{values}}{Vector of values}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Filter-to_list"></a>}}
\if{latex}{\out{\hypertarget{method-Filter-to_list}{}}}
\subsection{Method \code{to_list()}}{
Convert to list for API
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Filter$to_list()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List representation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Filter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Filter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Filter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
