% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson_distribution.R
\name{poisson_}
\alias{poisson_}
\title{Poisson Distribution Function}
\usage{
poisson_(k = NULL, lam = NULL, learn = FALSE, interactive = FALSE)
}
\arguments{
\item{k}{Optional number of occurrences (not needed for interactive mode)}

\item{lam}{Optional expected value lambda (not needed for interactive mode)}

\item{learn}{Logical, if TRUE shows step-by-step explanation}

\item{interactive}{Logical, if TRUE enables interactive practice mode}
}
\value{
The Poisson probability (for non-interactive mode)
}
\description{
This function calculates the Poisson distribution probability.
}
\examples{
lam <- 2
k <- 3

# Simple calculation
poisson_(k, lam)

# Learning mode
poisson_(k, lam, learn = TRUE)

# Interactive mode
if(interactive()){
poisson_(interactive = TRUE)
}

}
