% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefficient_of_variation.R
\name{cv}
\alias{cv}
\title{Coefficient of Variation Function}
\usage{
cv(x = NULL, learn = FALSE, interactive = FALSE)
}
\arguments{
\item{x}{Optional numeric vector (not needed for interactive mode)}

\item{learn}{Logical, if TRUE shows step-by-step explanation}

\item{interactive}{Logical, if TRUE enables interactive practice mode}
}
\value{
The coefficient of variation of the vector (for non-interactive mode)
}
\description{
This function calculates the coefficient of variation of a numbers vector.
}
\examples{
data <- c(10,4,5,7,3,4,1)

# Simple calculation
cv(data)

# Learning mode
cv(data, learn = TRUE)

# Interactive mode
if(interactive()){
cv(interactive = TRUE)
}

}
