% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_deviation.R
\name{average_deviation}
\alias{average_deviation}
\title{Average Absolute Deviation Function}
\usage{
average_deviation(x = NULL, learn = FALSE, interactive = FALSE)
}
\arguments{
\item{x}{Optional numeric vector (not needed for interactive mode)}

\item{learn}{Logical, if TRUE shows step-by-step explanation}

\item{interactive}{Logical, if TRUE enables interactive practice mode}
}
\value{
The average absolute deviation of the vector (for non-interactive mode)
}
\description{
This function calculates the average absolute deviation of a numbers vector.
}
\examples{
data <- c(7,2,5,7,1,4,12)

# Simple calculation
average_deviation(data)

# Learning mode
average_deviation(data, learn = TRUE)

# Interactive mode
if(interactive()){
average_deviation(interactive = TRUE)
}

}
