% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_methods.R
\name{compare_multivariate_methods}
\alias{compare_multivariate_methods}
\title{Compare Multivariate Outlier Detection Methods}
\usage{
compare_multivariate_methods(data, methods, params)
}
\arguments{
\item{data}{Input dataset (must be a data.frame)}

\item{methods}{Vector of method names to compare. Available methods are:
"lof", "dbscan", "knn", "mahalanobis"}

\item{params}{List of parameters for each method. Must contain named lists:
\itemize{
  \item lof: list(K=numeric, threshold=numeric)
  \item dbscan: list(max_distance_threshold=numeric, min_pts=numeric)
  \item knn: list(d=numeric, K=numeric)
  \item mahalanobis: list(alpha=numeric)
}}
}
\value{
None, produces a visualization matrix comparing the outliers detected by each method.
}
\description{
Compares multiple multivariate outlier detection methods on the same dataset
}
\examples{
inputData = t(matrix(c(3,2,3.5,12,4.7,4.1,5.2,
4.9,7.1,6.1,6.2,5.2,14,5.3),2,7,dimnames=list(c("r","d"))))
inputData = data.frame(inputData)
methods = c("lof", "dbscan", "knn", "mahalanobis")
params = list(
  lof = list(K=3, threshold=0.5),
  dbscan = list(max_distance_threshold=4, min_pts=3),
  knn = list(d=3, K=2),
  mahalanobis = list(alpha=0.7)
)
compare_multivariate_methods(inputData, methods, params)

}
\author{
Andriy Protsak
}
