% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HPart.R
\name{HPart}
\alias{HPart}
\alias{as.HPart}
\alias{as.HPart.HPart}
\alias{as.HPart.default}
\alias{as.HPart.list}
\alias{as.HPart.phylo}
\alias{is.HPart}
\alias{print.HPart}
\alias{as.phylo.HPart}
\alias{plot.HPart}
\title{Hierarchical partition structure}
\usage{
as.HPart(tree, tipLabels)

\method{as.HPart}{HPart}(tree, tipLabels = NULL)

\method{as.HPart}{default}(tree, tipLabels = NULL)

\method{as.HPart}{list}(tree, tipLabels = NULL)

\method{as.HPart}{phylo}(tree, tipLabels = TipLabels(tree))

is.HPart(x)

\method{print}{HPart}(x, ...)

\method{as.phylo}{HPart}(x, ...)

\method{plot}{HPart}(x, ...)
}
\arguments{
\item{tree}{An object to convert to an HPart structure, in a supported format
(see details).}

\item{tipLabels}{Character vector specifying sequence in which to order
tip labels.}

\item{x}{\code{HPart} object to plot.}

\item{\dots}{Additional arguments to \code{\link[ape:plot.phylo]{plot.phylo}}.}
}
\value{
\code{HPart()} returns a structure containing a pointer to a C++
representation of a hierarchical partition structure.
}
\description{
A structure of class \code{HPart} comprises a pointer to a C++ representation of
hierarchical partitions, with the attribute \code{tip.label} recording the
character labels of its leaves.  \code{HPart} objects with identical tip labels
can be compared using \code{\link[=HierarchicalMutualInfo]{HierarchicalMutualInfo()}}.
}
\details{
An \code{HPart} object may be created from various representations of hierarchical
structures:
\itemize{
\item a tree (possibly phylogenetic) of class \code{phylo}
\item A hierarchical list of lists, in which elements are represented by integers
1 to n
\item A vector, which will be interpreted as a flat structure
in which all elements bearing the same label are assigned to the same cluster
}
}
