% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_frailty.R
\name{post_frailty_confint}
\alias{post_frailty_confint}
\title{Posterior Frailty Confidence Intervals}
\usage{
post_frailty_confint(
  object,
  level = 0.95,
  flag_eps = FALSE,
  flag_alpha = FALSE
)
}
\arguments{
\item{object}{S3 object of class 'AdPaik' returned by the main model output, that contains all the information for the computation
of the frailty standard deviation.}

\item{level}{A numeric value representing the confidence level for the posterior frailty confidence intervals.
Default is 0.95 for 95\% confidence.}

\item{flag_eps}{Logical flag indicating whether to extract only the time-dependent posterior frailty estimates. Default is FALSE.}

\item{flag_alpha}{Logical flag indicating whether to extract only the time-independent posterior frailty estimates. Default is FALSE.}
}
\value{
A list for posterior frailty confidence intervals, depending on the flag_eps and flag_alpha values.
Specifically:
\itemize{
\item A list of length equal to the N containing posterior frailty confidence intervals for \eqn{\alpha_j, \forall j}.
In this case the flag_eps must be FALSE and the flag_alpha must be TRUE.
\item A list of length equal to the NxL containing posterior frailty confidence intervals for \eqn{\epsilon_{jk}, \forall j,k}.
In this case the flag_eps must be TRUE and the flag_alpha must be FALSE.
\item A list of length equal to the NxL containing posterior frailty confidence intervals for \eqn{Z_{jk} \forall j,k}.
In this case the flag_eps must be FALSE and the flag_alpha must be FALSE.
}
}
\description{
Function for computing the posterior frailty confidence intervals of the time-dependent shared frailty Cox model.

Recalling the structure of the frailty \eqn{Z_{jk} = \alpha_j + \epsilon_{jk}, \forall j,k}
with \eqn{k=1,\dots,L} and \eqn{j=1,\dots,N} as being composed by the sum
of two independent gamma distributions:
\itemize{
\item \eqn{\alpha_j \sim gamma(\mu_1/\nu, 1/\nu), \forall j}
\item \eqn{\epsilon_{jk} \sim gamma(\mu_2/\gamma_k, 1/\gamma_k), \forall j,k}
}

The posterior frailty estimate is \eqn{\hat{Z}_{jk} = \hat{\alpha}_{j}/\hat{\alpha}_{max} + \hat{\epsilon}_{jk}/\hat{\epsilon}_{max}}.
This function allows to get the confidence intervals of either the entire posterior frailty estimates \eqn{\hat{Z}_{jk}}
or its time-independent \eqn{\frac{\hat{\alpha}_{j}}{\hat{\alpha}_{\text{max}}}} or
time-dependent \eqn{\frac{\hat{\epsilon}_{jk}}{\hat{\epsilon}_{\text{max}}}} components.
The user can control which components to display using the flag_eps and flag_alpha parameters.
Only one of these flags can be set to TRUE at a time.
}
\examples{
# Consider the 'Academic Dropout dataset'
data(data_dropout)

# Define the variables needed for the model execution
formula <- time_to_event ~ Gender + CFUP + cluster(group)
time_axis <- c(1.0, 1.4, 1.8, 2.3, 3.1, 3.8, 4.3, 5.0, 5.5, 5.8, 6.0)
eps <- 1e-10
categories_range_min <- c(-8, -2, eps, eps, eps)
categories_range_max <- c(-eps, 0, 1 - eps, 1, 10)

\donttest{
# Call the main model
result <- AdPaikModel(formula, data_dropout, time_axis,
                      categories_range_min, categories_range_max)

post_frailty_confint(result)
}

}
