% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdPaikModel.R
\name{ll_AdPaik_centre_1D}
\alias{ll_AdPaik_centre_1D}
\title{One-Dimensional Group log-Likelihood Function}
\usage{
ll_AdPaik_centre_1D(
  param_onedim,
  index_param_onedim,
  params,
  dataset,
  dropout_matrix,
  e_matrix
)
}
\arguments{
\item{param_onedim}{One dimensional parameter, with respect to which the log-likelihood function
must be optmize.}

\item{index_param_onedim}{Index of the previous parameter inside the parameter vector.}

\item{params}{Parameter vector.}

\item{dataset}{Matrix of dataset regressors, with a number of rows equal to the number of individuals in a cluster.}

\item{dropout_matrix}{Binary matrix indicating in which interval of the time domain and individual failed. For an individual,
the sum of the row elements must be equal to 1 (if he/she failed) or 0 (if he/she does not failed).
It has dimension equal to (n_individuals, n_intervals)}

\item{e_matrix}{Matrix of dimension (n_individual, n_intervals), where each element contains the evaluation of the temporal
integral, performed through the function @param time_int_eval.}
}
\value{
Centre log-likelihood function.
}
\description{
This function simply implements the group log-likelihood function, following the definition.
It is internally used by @ll_AdPaik_1D and, therefore, it requires as first and second argument the parameter according to which the
global log-likelihood is one-dimensionally optimized and its position inside the vector of parameters.
}
\keyword{internal}
