% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_func_ZINB.R
\name{TaxaNorm_Normalization}
\alias{TaxaNorm_Normalization}
\title{Function to run TaxaNorm algorithm}
\usage{
TaxaNorm_Normalization(
  data,
  depth = NULL,
  group = NULL,
  meta.data = NULL,
  filter.cell.num = 10,
  filter.taxa.count = 0,
  random = FALSE,
  ncores = NULL
)
}
\arguments{
\item{data}{(Required) Input data; should be either a phyloseq object or a count matrix}

\item{depth}{sequencing depth if pre-calculated. It should be a vector with the same length and order as the column of the count data}

\item{group}{condition variables if samples are from multiple groups; should be correpsond to the column of the count data. default is NULL, where no grouping is considered}

\item{meta.data}{meta data for Taxa}

\item{filter.cell.num}{taxa with "filter.cell.num" in more than the value provided will be filtered}

\item{filter.taxa.count}{"filter.taxa.count" samples will be removed before testing. default is keep taxa appear in at least 10 samples within each group}

\item{random}{calculate randomized normal quantile residual}

\item{ncores}{whether multiple cores is used for parallel computing; default is max(1, detectCores() - 1)}
}
\value{
a TaxaNorm Object containing the normalized count values and accessory information
}
\description{
Function to run TaxaNorm algorithm
}
\examples{
\donttest{
data("TaxaNorm_Example_Input", package = "TaxaNorm")
Normalized_Data <- TaxaNorm_Normalization(data= TaxaNorm_Example_Input,
                                         depth = NULL,
                                         group = sample_data(TaxaNorm_Example_Input)$body_site,
                                         meta.data = NULL,
                                         filter.cell.num = 10,
                                         filter.taxa.count = 0,
                                         random = FALSE,
                                         ncores = 1)}
}
