% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SK_VOLab_EBLUP_LME.f.R
\name{SK_VOLab_EBLUP_LME.f}
\alias{SK_VOLab_EBLUP_LME.f}
\title{taper volume estimation}
\usage{
SK_VOLab_EBLUP_LME.f(
  xm,
  ym,
  a = 0,
  b = 1,
  Ht,
  par.lme,
  Rfn = list(fn = "sig2"),
  IntPolOpt = TRUE,
  ...
)
}
\arguments{
\item{xm}{relative heights for which measurements are available}

\item{ym}{corresponding diameter measurements in height \code{xm}}

\item{a}{relative height of lower threshold of stem section}

\item{b}{relative height of upper threshold of stem section}

\item{Ht}{tree height}

\item{par.lme}{List of taper model parameters obtained by \code{\link{TapeR_FIT_LME.f}}}

\item{Rfn}{list with function name to provide estimated or assumed residual 
variances for the given measurements, optionally parameters for such functions}

\item{IntPolOpt}{option for method of interpolation, if TRUE using a natural 
interpolating spline (\code{\link[stats]{splinefun}}), if FALSE using a smoothing 
spline (\code{\link[stats]{smooth.spline}}); defaults to TRUE}

\item{...}{not currently used}
}
\value{
List with two elements, the estimated volume and its variance
}
\description{
Internal function not usually called by users
}
\details{
with \code{Rfn=list(fn="zero")} one can decide whether the 
measured diameters are forced to lie exactly on the taper curve; this 
interferes somewhat with the \code{IntPolOpt}, which determines the method of
taper curve point interpolation for integration. The default \code{TRUE} 
(used throughout all function calls) applies natural interpolating splines, 
hence this does not contradict the optional use of \code{Rfn=list(fn="zero")}.
}
\author{
Edgar Kublin
}
