% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-TableContainer.r
\name{TableContainer}
\alias{TableContainer}
\title{The constructor function for TableContainer}
\usage{
TableContainer(table = NULL, rowData = NULL, colData = NULL, metaData = NULL)
}
\arguments{
\item{table}{A matrix, data.frame, or NULL.}

\item{rowData}{A data.frame or NULL object describing the rows.}

\item{colData}{A data.frame or NULL object describing the columns.}

\item{metaData}{A list or NULL containing arbitrary metadata associated
with the overall data.}
}
\value{
A TableContainer object.
}
\description{
Creates a TableContainer object with the specified matrix, rowData,
colData, and metadata.
}
\examples{
tbl <- matrix(1:12, nrow = 3, ncol = 4)
row_dt <- data.frame(row1 = 1:3, row2 = letters[1:3])
col_dt <- data.frame(col1 = 1:4, col2 = letters[1:4])
meta_dt <- list(meta1 = "meta1", meta2 = "meta2")

TableContainer(
    table = tbl,
    rowData = row_dt,
    colData = col_dt,
    metaData = meta_dt
)

}
