% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizedgame.R
\name{normalizedgame}
\alias{normalizedgame}
\title{Normalized game}
\usage{
normalizedgame(v, binary = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}
}
\value{
The characteristic function of the 0-1-normalized game, the 0-(-1) normalized game or the 0-0 normalized game; as a vector in binary order if \code{binary=TRUE} and in lexicographic order otherwise.
}
\description{
Given a game, this function returns the characteristic function of its 0-1-normalization, its 0-(-1) normalization or its 0-0 normalization, as appropriate.
}
\details{
A game \eqn{v\in G^N} is: 0-1 normalized if \eqn{v(i)=0} for all \eqn{i\in N} and \eqn{v(N)=1};
0-0 normalized if \eqn{v(i)=0} for all \eqn{i\in N} and \eqn{v(N)=0};
and 0-(-1) normalized if \eqn{v(i)=0} for all \eqn{i\in N} and \eqn{v(N)=-1}.

If \eqn{v(N)>\sum_{i\in N}v(i)}, the 0-1 normalized game of \eqn{v}, \eqn{v_{0,1}\in G^N}, is  defined by
\deqn{v_{0,1}(S)=\frac{v(S)-\sum_{i\in S}v(i)}{v(N)-\sum_{i\in N}v(i)}} for all \eqn{S\in 2^N}.

If \eqn{v(N)<\sum_{i\in N}v(i)}, the 0-(-1) normalized game of \eqn{v}, \eqn{v_{0,-1}\in G^N}, is  defined by
\deqn{v_{0,-1}(S)=-\frac{v(S)-\sum_{i\in S}v(i)}{v(N)-\sum_{i\in N}v(i)}} for all \eqn{S\in 2^N}.

If \eqn{v(N)=\sum_{i\in N}v(i)}, the 0-0 normalized game of \eqn{v}, \eqn{v_{0,0}\in G^N}, is  defined by
\deqn{v_{0,0}(S)=v(S)-\sum_{i\in S}v(i)} for all \eqn{S\in 2^N}.
}
\examples{
v <- c(1, 5, 11, 6, 11, 15, 16)
normalizedgame(v, binary = TRUE)
w <- c(4, 3, 8, 16, 17, 18, 15)
normalizedgame(w)
z <- c(2,3,5,10,12,14,5)
normalizedgame(z)
}
\seealso{
\link{strategicallyequivalentcheck}, \link{zeronormalizedcheck}, \link{zeronormalizedgame}
}
