#' Plot fo the time series and its smoothed version in ggplo
#'
#' It plots the univariate or bivariate time series and its smoothed version (trend) using ggplot. It directly uses the output of trend_estimate.
#'
#' @param smoothedTS Is an object generated by the function trend_estimate
#' @param title Main title of the graph
#' @param xlab Common x label
#' @param ylab A 2-length vector of characters.
#'
#'
#'
#' @return The ggplot of the original time series, their treind and its approximated 95% bands
#'

plot_trend<-function(smoothedTS, title = NULL,  xlab = "Time", ylab = names(dat)[1:2]){
  dvar<-smoothedTS$diag.var.tau
  tau<-smoothedTS$tau
  if(smoothedTS$bivariate){
    dat<-as.data.frame(smoothedTS$dat)
      p1 <- ggplot() +
        geom_point(data=dat, aes(x = as.numeric(time(smoothedTS$dat)), y = dat[,1]), col = rgb(0,0.7,0.7,1))+
        labs(title = title, y = ylab[1])+
        theme(axis.title.x = element_blank(),
              axis.text.x = element_blank(),
              axis.ticks.x = element_blank())+
        geom_line(data = dat, aes(x = as.numeric(time(smoothedTS$dat)), y = dat[,1]),col = rgb(0,0.7,0.7,1)) +
        geom_line(aes(x = as.numeric(time(smoothedTS$dat)), y = tau[,1]))+
        geom_ribbon(aes(x = as.numeric(time(smoothedTS$dat)),ymin = tau[,1]-2*sqrt(dvar[,1]), ymax = tau[,1]+2*sqrt(dvar[,1])),
                    alpha = 0.25,
                    linetype = 1,
                    #colour = rgb(0,0.7,0.7,1), #border line color
                    size = 1,
                    fill = rgb(0,0.7,0.7,1))#+
        #theme(legend.position = c(0, 1),
        #     legend.justification = c(0, 1))
      p2 <- ggplot() +
      geom_point(data = dat, aes(x = as.numeric(time(smoothedTS$dat)), y = dat[,2]), col = rgb(0,0.7,0.7,1))+
      labs( y = ylab[2], x = xlab)+
      geom_line(data = dat, aes(x = as.numeric(time(smoothedTS$dat)), y = dat[,2]),col = rgb(0,0.7,0.7,1)) +
      geom_line(aes(x = as.numeric(time(smoothedTS$dat)), y = tau[,2]))+
      geom_ribbon(aes(x = as.numeric(time(smoothedTS$dat)),ymin = tau[,2]-2*sqrt(dvar[,2]), ymax = tau[,2]+2*sqrt(dvar[,2])),
                  alpha = 0.25,
                  linetype = 1,
                  #colour = rgb(0,0.7,0.7,1), #border line color
                  size = 1,
                  fill = rgb(0,0.7,0.7,1))

    grid.arrange(p1, p2, nrow = 2)
    }else{ #only one serie
      dat<-as.numeric(smoothedTS$dat)
      ggplot() +
        geom_point(aes(x = as.numeric(time(smoothedTS$dat)), y = dat),col = rgb(0,0.7,0.7,1)) +
        labs( title = title, y = ylab, x = xlab)+
        geom_line(aes(x = as.numeric(time(smoothedTS$dat)), y = dat),col = rgb(0,0.7,0.7,1)) +
        geom_line(aes(x = as.numeric(time(smoothedTS$dat)), y = tau))+
        geom_ribbon(aes(x = as.numeric(time(smoothedTS$dat)), ymin = tau-2*sqrt(dvar), ymax = tau+2*sqrt(dvar)),
                    alpha = 0.25,
                    linetype = 1,
                    size = 1,
                    fill = rgb(0,0.7,0.7,1))
    }

}
