% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateTFactS.R
\name{calculateTFactS}
\alias{calculateTFactS}
\title{calculates TFactS}
\usage{
calculateTFactS(
  DEGs,
  catalog,
  TFs,
  all.targets,
  Q.value = FALSE,
  lambda1 = seq(0.05, 0.5, 0.01),
  lambda2 = 0.05,
  nRep = 100,
  TF.col = "TF..OFFICIAL_TF_CODING_GENE_NAME."
)
}
\arguments{
\item{DEGs}{a character vector of DEGs (differentially expressed genes)}

\item{catalog}{a data frame of TFactS catalog (ver. 2)}

\item{TFs}{a character vector of transcription factor}

\item{all.targets}{a character vector of all target genes}

\item{Q.value}{logical. If it is TRUE, Q.value by Storey method.}

\item{lambda1}{a vector of the lambda values utilized to obtain pi0.lambda}

\item{lambda2}{a user-specified threshold of E-value (default: 0.05)}

\item{nRep}{number of random selections (default: 100)}

\item{TF.col}{the name of the column that contains the TF names}
}
\value{
data.frame
}
\description{
This function calculates TFactS
}
\examples{
data(DEGs)
data(catalog)

tftg <- extractTFTG(DEGs, catalog)
TFs <- tftg$TFs
all.targets <- tftg$all.targets

res <- calculateTFactS(DEGs, catalog, TFs, all.targets)

}
\references{
Essaghir A et al. Nucleic Acids Res. 2010 Jun;38(11):e120.
}
\author{
Atsushi Fukushima
}
