% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{Plot.Radar}
\alias{Plot.Radar}
\title{Plot.Radar}
\usage{
Plot.Radar(
  dt = NULL,
  AggMethod = "mean",
  PreAgg = TRUE,
  YVar = NULL,
  GroupVar = NULL,
  YVarTrans = "Identity",
  Height = NULL,
  Width = NULL,
  Title = "Radar Plot",
  ShowLabels = FALSE,
  EchartsTheme = "macarons",
  ShowSymbol = FALSE,
  TextColor = "white",
  title.fontSize = 22,
  title.fontWeight = "bold",
  title.textShadowColor = "#63aeff",
  title.textShadowBlur = 3,
  title.textShadowOffsetY = 1,
  title.textShadowOffsetX = -1,
  ContainLabel = TRUE,
  DarkMode = FALSE,
  Debug = FALSE
)
}
\arguments{
\item{dt}{source data.table}

\item{AggMethod}{character}

\item{PreAgg}{logical}

\item{YVar}{Y-Axis variable name. You can supply multiple YVars}

\item{GroupVar}{One Grouping Variable}

\item{YVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{Height}{"400px"}

\item{Width}{"200px"}

\item{Title}{"Title"}

\item{ShowLabels}{character}

\item{EchartsTheme}{Provide an "Echarts" theme}

\item{ShowSymbol}{= FALSE}

\item{TextColor}{"Not Implemented"}

\item{title.fontSize}{22}

\item{title.fontWeight}{"bold"}

\item{title.textShadowColor}{'#63aeff'}

\item{title.textShadowBlur}{3}

\item{title.textShadowOffsetY}{1}

\item{title.textShadowOffsetX}{-1}

\item{ContainLabel}{TRUE}

\item{DarkMode}{FALSE}

\item{Debug}{Debugging purposes}
}
\value{
plot
}
\description{
Plot.Radar
}
\examples{
# Create Data
dt <- data.table::data.table(Y = pnorm(q = runif(8)), GV = sample(LETTERS[1:4], 8, TRUE))

# Create plot
AutoPlots::Plot.Radar(
  dt = dt,
  AggMethod = "mean",
  PreAgg = FALSE,
  YVar = "Y",
  GroupVar = "GV",
  YVarTrans = "Identity",
  Height = NULL,
  Width = NULL,
  Title = 'Radar Plot',
  ShowLabels = FALSE,
  EchartsTheme = "macarons",
  ShowSymbol = FALSE,
  TextColor = "black",
  title.fontSize = 22,
  title.fontWeight = "bold",
  title.textShadowColor = '#63aeff',
  title.textShadowBlur = 3,
  title.textShadowOffsetY = 1,
  title.textShadowOffsetX = -1,
  ContainLabel = TRUE,
  DarkMode = FALSE,
  Debug = FALSE)

}
\seealso{
Other Standard Plots: 
\code{\link{Plot.ACF}()},
\code{\link{Plot.Area}()},
\code{\link{Plot.BarPlot3D}()},
\code{\link{Plot.Bar}()},
\code{\link{Plot.Box}()},
\code{\link{Plot.Copula3D}()},
\code{\link{Plot.Copula}()},
\code{\link{Plot.CorrMatrix}()},
\code{\link{Plot.Density}()},
\code{\link{Plot.Donut}()},
\code{\link{Plot.HeatMap}()},
\code{\link{Plot.Histogram}()},
\code{\link{Plot.Line}()},
\code{\link{Plot.PACF}()},
\code{\link{Plot.Parallel}()},
\code{\link{Plot.Pie}()},
\code{\link{Plot.ProbabilityPlot}()},
\code{\link{Plot.River}()},
\code{\link{Plot.Rosetype}()},
\code{\link{Plot.Scatter3D}()},
\code{\link{Plot.Scatter}()},
\code{\link{Plot.StackedBar}()},
\code{\link{Plot.Step}()},
\code{\link{Plot.WordCloud}()}
}
\author{
Adrian Antico
}
\concept{Standard Plots}
