% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{frequency_table}
\alias{frequency_table}
\title{Generate frequency table for categorical variable}
\usage{
frequency_table(data, col, weight_col = NULL)
}
\arguments{
\item{data}{A data.frame containing survey data}

\item{col}{Character string specifying column name for categorical variable}

\item{weight_col}{Character string specifying column name containing weights (optional)}
}
\value{
A data.frame with frequency statistics
}
\description{
This function creates a frequency table for a categorical variable,
optionally incorporating survey weights.
}
\examples{
data <- data.frame(gender = c("M", "F", "M", "F"), weight = c(1, 1.2, 0.8, 1.1))
freq_table <- frequency_table(data, "gender")
weighted_freq <- frequency_table(data, "gender", "weight")
}
