% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{block_bootstrap}
\alias{block_bootstrap}
\title{Create Block Bootstrap Samples}
\usage{
block_bootstrap(X, n_boot, block_length = NULL, seed = NULL)
}
\arguments{
\item{X}{Matrix where rows are time points and columns are variables.}

\item{n_boot}{Number of bootstrap samples to generate.}

\item{block_length}{Length of each block. If NULL, defaults to
\code{ceiling(sqrt(nrow(X)))}.}

\item{seed}{Optional random seed for reproducibility.}
}
\value{
A 3-dimensional array of dimension (nrow(X), ncol(X), n_boot)
containing the bootstrap samples.
}
\description{
Generates block bootstrap samples for time series data, preserving temporal
dependence structure. Uses non-overlapping blocks of specified length with
random block selection with replacement.
}
\details{
Block bootstrapping is essential for time series data to preserve the
autocorrelation structure within blocks. The procedure:
\enumerate{
\item Divides the original series into blocks of length L
\item Randomly samples blocks with replacement
\item Concatenates sampled blocks to form each bootstrap sample
}

The default block length of \eqn{\sqrt{T}} balances capturing dependence
structure against having sufficient blocks for resampling variation.
}
\section{Synchronization}{

For multivariate series, blocks are sampled synchronously across all
variables to preserve cross-sectional dependence. This is critical when
bootstrap samples are used to construct confidence intervals for statistics
that depend on the joint distribution.
}

\references{
Kunsch, H. R. (1989). The Jackknife and the Bootstrap for General Stationary
Observations. The Annals of Statistics, 17(3), 1217-1241.

Politis, D. N., & Romano, J. P. (1994). The Stationary Bootstrap. Journal
of the American Statistical Association, 89(428), 1303-1313.
}
\keyword{internal}
