
#include "bd.h"

bool bd(StanTree& x, xinfo& xi, dinfo& di, pinfo& pi, double sigma, 
	std::vector<size_t>& nv, std::vector<double>& pv, bool aug, Random& random)
{
   StanTree::npv goodbots;  //nodes we could birth at (split on)
   double PBx = getpb(x,xi,pi,goodbots); //prob of a birth at x

   if(random.uniform() < PBx) { //do birth or death

      
      //draw proposal
      StanTree::StanTree_p nx; //bottom node
      size_t v,c; //variable and cutpoint
      double pr; //part of metropolis ratio from proposal and prior
      bprop(x,xi,pi,goodbots,PBx,nx,v,c,pr,nv,pv,aug,random);

      
      //compute sufficient statistics
      size_t nr,nl; //counts in proposed bots
      double syl, syr; //sum of y in proposed bots
      getsuff(x,nx,v,c,xi,di,nl,syl,nr,syr);

      
      //compute alpha
      double alpha=0.0, lalpha=0.0;
      double lhl, lhr, lht;
      if((nl>=5) && (nr>=5)) { //cludge?
         lhl = lh(nl,syl,sigma,pi.eta);
         lhr = lh(nr,syr,sigma,pi.eta);
         lht = lh(nl+nr,syl+syr,sigma,pi.eta);
   
         alpha=1.0;
         lalpha = log(pr) + (lhl+lhr-lht) + log(sigma);
         lalpha = std::min(0.0,lalpha);
      }

      
      //try metrop
      double mul,mur; //means for new bottom nodes, left and right
      double uu = random.uniform();
      bool dostep = (alpha > 0) && (log(uu) < lalpha);
      if(dostep) {
         mul = drawnodemu(nl,syl,pi.eta,sigma,random);
         mur = drawnodemu(nr,syr,pi.eta,sigma,random);
         x.birthp(nx,v,c,mul,mur);
	 nv[v]++;
         return true;
      } else {
         return false;
      }
   } else {
      
      //draw proposal
      double pr;  //part of metropolis ratio from proposal and prior
      StanTree::StanTree_p nx; //nog node to death at
      dprop(x,xi,pi,goodbots,PBx,nx,pr,random);

      
      //compute sufficient statistics
      size_t nr,nl; //counts at bots of nx
      double syl, syr; //sum at bots of nx
      getsuff(x, nx->getl(), nx->getr(), xi, di, nl, syl, nr, syr);

      
      //compute alpha
      double lhl, lhr, lht;
      lhl = lh(nl,syl,sigma,pi.eta);
      lhr = lh(nr,syr,sigma,pi.eta);
      lht = lh(nl+nr,syl+syr,sigma,pi.eta);

      double lalpha = log(pr) + (lht - lhl - lhr) - log(sigma);
      lalpha = std::min(0.0,lalpha);

      
      //try metrop
      double mu;
      if(log(random.uniform()) < lalpha) {
         mu = drawnodemu(nl+nr,syl+syr,pi.eta,sigma,random);
	 nv[nx->GetSplitVar()]--;
         x.deathp(nx,mu);
         return true;
      } else {
         return false;
      }
   }
}
