% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R, R/convenience.R
\name{ReadVizgen}
\alias{ReadVizgen}
\alias{LoadVizgen}
\title{Read and Load MERFISH Input from Vizgen}
\usage{
ReadVizgen(
  data.dir,
  transcripts = NULL,
  spatial = NULL,
  molecules = NULL,
  type = "segmentations",
  mol.type = "microns",
  metadata = NULL,
  filter = NA_character_,
  z = 3L
)

LoadVizgen(data.dir, fov, assay = "Vizgen", z = 3L)
}
\arguments{
\item{data.dir}{Path to the directory with Vizgen MERFISH files; requires at
least one of the following files present:
\itemize{
 \item \dQuote{\code{cell_by_gene.csv}}: used for reading count matrix
 \item \dQuote{\code{cell_metadata.csv}}: used for reading cell spatial
 coordinate matrices
 \item \dQuote{\code{detected_transcripts.csv}}: used for reading molecule
 spatial coordinate matrices
}}

\item{transcripts}{Optional file path for counts matrix; pass \code{NA} to
suppress reading counts matrix}

\item{spatial}{Optional file path for spatial metadata; pass \code{NA} to
suppress reading spatial coordinates. If \code{spatial} is provided and
\code{type} is \dQuote{segmentations}, uses \code{dirname(spatial)} instead of
\code{data.dir} to find HDF5 files}

\item{molecules}{Optional file path for molecule coordinates file; pass
\code{NA} to suppress reading spatial molecule information}

\item{type}{Type of cell spatial coordinate matrices to read; choose one
or more of:
\itemize{
 \item \dQuote{segmentations}: cell segmentation vertices; requires
 \href{https://cran.r-project.org/package=hdf5r}{\pkg{hdf5r}} to be
  installed and requires a directory \dQuote{\code{cell_boundaries}} within
  \code{data.dir}. Within \dQuote{\code{cell_boundaries}}, there must be
  one or more HDF5 file named \dQuote{\code{feature_data_##.hdf5}}
 \item \dQuote{centroids}: cell centroids in micron coordinate space
 \item \dQuote{boxes}: cell box outlines in micron coordinate space
}}

\item{mol.type}{Type of molecule spatial coordinate matrices to read;
choose one or more of:
\itemize{
 \item \dQuote{pixels}: molecule coordinates in pixel space
 \item \dQuote{microns}: molecule coordinates in micron space
}}

\item{metadata}{Type of available metadata to read;
choose zero or more of:
\itemize{
 \item \dQuote{volume}: estimated cell volume
 \item \dQuote{fov}: cell's fov
}}

\item{filter}{A character to filter molecules by, pass \code{NA} to skip
molecule filtering}

\item{z}{Z-index to load; must be between 0 and 6, inclusive}

\item{fov}{Name to store FOV as}

\item{assay}{Name to store expression matrix as}
}
\value{
\code{ReadVizgen}: A list with some combination of the
following values:
\itemize{
 \item \dQuote{\code{transcripts}}: a
 \link[Matrix:dgCMatrix-class]{sparse matrix} with expression data; cells
  are columns and features are rows
 \item \dQuote{\code{segmentations}}: a data frame with cell polygon outlines in
  three columns: \dQuote{x}, \dQuote{y}, and \dQuote{cell}
 \item \dQuote{\code{centroids}}: a data frame with cell centroid
  coordinates in three columns: \dQuote{x}, \dQuote{y}, and \dQuote{cell}
 \item \dQuote{\code{boxes}}: a data frame with cell box outlines in three
  columns: \dQuote{x}, \dQuote{y}, and \dQuote{cell}
 \item \dQuote{\code{microns}}: a data frame with molecule micron
  coordinates in three columns: \dQuote{x}, \dQuote{y}, and \dQuote{gene}
 \item \dQuote{\code{pixels}}: a data frame with molecule pixel coordinates
  in three columns: \dQuote{x}, \dQuote{y}, and \dQuote{gene}
 \item \dQuote{\code{metadata}}: a data frame with the cell-level metadata
  requested by \code{metadata}
}

\code{LoadVizgen}: A \code{\link[SeuratObject]{Seurat}} object
}
\description{
Read and load in MERFISH data from Vizgen-formatted files
}
\note{
This function requires the
\href{https://cran.r-project.org/package=data.table}{\pkg{data.table}} package
to be installed
}
\section{Progress Updates with \pkg{progressr}}{

This function uses
\href{https://cran.r-project.org/package=progressr}{\pkg{progressr}} to
render status updates and progress bars. To enable progress updates, wrap
the function call in \code{\link[progressr]{with_progress}} or run
\code{\link[progressr:handlers]{handlers(global = TRUE)}} before running
this function. For more details about \pkg{progressr}, please read
\href{https://progressr.futureverse.org/articles/progressr-01-intro.html}{\code{vignette("progressr-intro")}}
}

\section{Parallelization with \pkg{future}}{

This function uses
\href{https://cran.r-project.org/package=future}{\pkg{future}} to enable
parallelization. Parallelization strategies can be set using
\code{\link[future]{plan}}. Common plans include \dQuote{\code{sequential}}
for non-parallelized processing or \dQuote{\code{multisession}} for parallel
evaluation using multiple \R sessions; for other plans, see the
\dQuote{Implemented evaluation strategies} section of
\code{\link[future:plan]{?future::plan}}. For a more thorough introduction
to \pkg{future}, see
\href{https://future.futureverse.org/articles/future-1-overview.html}{\code{vignette("future-1-overview")}}
}

\concept{future}
\concept{preprocessing}
