% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq_test_STPP.R
\name{chisq.test.stPP}
\alias{chisq.test.stPP}
\title{Chi-squared test for first-order separability of a spatio-temporal point process}
\usage{
chisq.test.stPP(
  X,
  n.space = 2L,
  n.time = 3L,
  s.region = c(0, 1, 0, 1),
  t.region = c(0, 1)
)
}
\arguments{
\item{X}{A numeric matrix or data frame with at least three columns giving event coordinates
\eqn{(x, y, t)}.}

\item{n.space}{Integer (>= 2). Number of bins per spatial axis. The contingency table has
\code{n.space^2} rows.}

\item{n.time}{Integer (>= 2). Number of temporal bins (columns of the contingency table).}

\item{s.region}{Numeric vector of length 4 giving the spatial bounding box
\code{c(xmin, xmax, ymin, ymax)}. Defaults to the unit box \code{c(0,1,0,1)}.}

\item{t.region}{Numeric vector of length 2 giving the temporal window \code{c(tmin, tmax)}
with \code{tmin < tmax}. Defaults to \code{c(0,1)}.}
}
\value{
A list with components:
\describe{
\item{chisq_s}{Numeric scalar. The chi-squared test statistic.}
\item{chisq_p}{Numeric scalar. The p-value of the chi-squared test.}
\item{counts}{Integer matrix of dimension \code{n.space^2} by \code{n.time} containing the space--time counts.}
}
}
\description{
Performs the classical (asymptotic) chi-squared test of first-order separability by
constructing a space-time contingency table of counts and applying a chi-squared test
of independence.
}
\details{
The spatial domain is partitioned into \code{n.space} bins in each coordinate direction
(yielding \code{n.space^2} spatial cells), and the temporal domain is partitioned into
\code{n.time} intervals. Bin boundaries are defined using empirical quantiles of the
observed coordinates, with the first/last boundaries fixed to the provided spatial and
temporal windows.

Events falling outside \code{s.region} or \code{t.region} are ignored (with a warning).
If the data contain many ties, quantile-based boundaries may coincide; in that case reduce
\code{n.space}/\code{n.time} or jitter the coordinates slightly.

This implementation uses \code{\link[stats]{chisq.test}} on the contingency table of space--time counts.
If expected counts are very small, the chi-squared approximation may be poor; in that case consider
using a Monte Carlo approach (e.g., block permutation) as implemented in \code{\link{chi2.test}}.
}
\examples{

lambda <- get.lambda.function(N = 200, g = 50, model = 4)
Lmax <- get.lambda.max(N = 200, g = 50, model = 4)
X <- rstpoispp(lambda, Lmax)
result <- chisq.test.stPP(X, n.space = 2, n.time = 2)
print(result)

}
\references{
Ghorbani M., Vafaei N., Dvořák J., Myllymäki M. (2021).
Testing the first-order separability hypothesis for spatio-temporal point patterns.
\emph{Computational Statistics and Data Analysis}, \bold{161}, 107245.
}
\seealso{
\code{\link{chi2.test}}, \code{\link[stats]{chisq.test}}
}
\author{
Jiří Dvořák \email{dvorak@karlin.mff.cuni.cz}\cr
}
