% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotProbs.R
\name{plotProbs}
\alias{plotProbs}
\title{Plots results from the selectSpecies function}
\usage{
plotProbs(
  result,
  traits,
  colors = c("lightblue", "blue"),
  xlim = NULL,
  ylim = NULL,
  xlab = NULL,
  ylab = NULL,
  zlab = "Probability",
  distance = 0.3,
  cex.lab = 1.5,
  box.col = "transparent",
  xbase = 0.5,
  ybase = 0.5,
  ...
)
}
\arguments{
\item{result}{A saved object from function selectSpecies()}

\item{traits}{A matrix of trait values where traits are columns and rows are species. If one trait is provided, then the function creates a 2D barplot of probabilities for each species. If two traits are provided, then the function creates a 3D barplot that illustrates probabilities of species located within a 2D trait space.}

\item{colors}{An optional vector of colors for plotting that must include at least two valid color names. The default color scheme is a ramp palette of lightblue to blue.}

\item{xlim}{Vector of two numbers denoting limits on x-axis.}

\item{ylim}{Vector of two numbers denoting limits on y-axis.}

\item{xlab}{Character string to describe x-axis.}

\item{ylab}{Character string to describe y-axis.}

\item{zlab}{Character string to describe z-axis. The default axis names is "Probabilities".}

\item{distance}{An optional number denoting distance between bars in 3d plot.}

\item{cex.lab}{An optional number denoting the size of the labels. The default is set to 1.5.}

\item{box.col}{An optional setting for the color of the box. The default setting is transparent.}

\item{xbase}{The length of the base of each 3d bar along the x-axis}

\item{ybase}{The length of the base of each 3d bar along the y-axis}

\item{...}{Additional arguments to pass to barplot() or lattice::cloud()}
}
\value{
2D barplot of probabilities for each species or 3D barplot that illustrates probabilities of species located within a 2D trait space
}
\description{
This function plots results (species probabilities/optimum solutions) from the selectSpecies() function
}
\examples{
### 1 trait constraint with maximum functional diversity and entropy
Spp <- 5 #S = number of species
trait <- as.matrix(data.frame(trait=c(1:Spp)))
rownames(trait) <- c(letters[1:nrow(trait)])
result1 <- selectSpecies(t2c=trait, constraints=c(3.5), t2d=trait, obj="QH", capd=FALSE)
plotProbs(result1,trait, xlab="Trait")

##### 2 traits: Constrain trait X to value 2.5, diversify trait Y
traitX <- matrix(c(rep(1,3),rep(2,3),rep(3,3)))
traitY <- matrix(c(rep(c(1,2,3),3)))
rownames(traitX) <- c(letters[1:9]); colnames(traitX) <- c("traitX")
rownames(traitY) <- c(letters[1:9]); colnames(traitY) <- c("traitY")
result2 <- selectSpecies(t2c=traitX,constraints=c(traitX=2.5),t2d=traitY,capd=TRUE,obj="QH")
plotProbs(result2,traits = cbind(traitX, traitY))
}
