% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_setFOR_nsm}
\alias{seasonder_setFOR_nsm}
\title{Set FOR Doppler Smoothing Factor (nsm)}
\usage{
seasonder_setFOR_nsm(seasonder_cs_object, nsm)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing FOR-related information.}

\item{nsm}{A numeric value specifying the new smoothing factor.}
}
\value{
The updated SeaSondeRCS object with the new \code{nsm} value.
}
\description{
This function sets the Doppler smoothing factor (\code{nsm}) in the SeaSondeRCS object
for FOR processing.
}
\examples{
# Set sample file paths
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
# Read the antenna pattern file to create a SeaSondeRAPM object
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
# Create a SeaSondeRCS object from a spectral file
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
cs_obj <- seasonder_setFOR_nsm(cs_obj, 3)
}
