% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_getDopplerSpectrumResolution}
\alias{seasonder_getDopplerSpectrumResolution}
\title{Calculate the Doppler Spectrum Resolution}
\usage{
seasonder_getDopplerSpectrumResolution(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing the necessary data
and metadata for Doppler spectrum analysis.}
}
\value{
A numeric value representing the Doppler spectrum resolution in Hertz (Hz).
}
\description{
This function computes the Doppler spectrum resolution for a given SeaSondeRCS
object. The resolution reflects the frequency difference between consecutive
Doppler bins in the spectrum.
}
\details{
The Doppler spectrum resolution is calculated using the formula:
\eqn{SpectralResolution = SweepRate / NumberOfDopplerCells}
where:
\itemize{
\item SweepRate is the frequency repetition rate of the radar, obtained
from the field \code{fRepFreqHz} in the object's header.
\item NumberOfDopplerCells is the total number of Doppler bins in the spectrum.
}

This calculation is fundamental for understanding the frequency spacing between
adjacent Doppler bins in the radar spectrum.
}
\seealso{
\code{\link{seasonder_getnDopplerCells}} to retrieve the number of Doppler cells.
\code{\link{seasonder_getSeaSondeRCS_headerField}} to access specific header fields.
}
