% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_MUSICInitProjections}
\alias{seasonder_MUSICInitProjections}
\title{Initialize Projection Matrix for MUSIC Algorithm}
\usage{
seasonder_MUSICInitProjections(bearings = 0)
}
\arguments{
\item{bearings}{A numeric vector representing the bearings (in degrees) for which projections are initialized.
Defaults to \code{0}.}
}
\value{
A 2 x n matrix of complex values, each initialized to \code{NA_complex_}, with row names
\code{"single"} and \code{"dual"}. The input bearings are stored as an attribute.
}
\description{
This function initializes a projection matrix for use in the MUSIC algorithm.
}
\details{
The function creates a 2 x n complex matrix, where n is the number of bearings.
The matrix rows are labeled:
\itemize{
\item \code{"single"}: For single projections.
\item \code{"dual"}: For dual projections.
}

An attribute \code{"bearings"} is attached to the matrix, storing the input bearings vector.
}
\seealso{
\code{\link{seasonder_MUSICInitCov}} for initializing covariance matrices.
}
