% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scriptmapr.R
\name{scriptmapr}
\alias{scriptmapr}
\title{Display content of input script in 'Cytoscape'}
\usage{
scriptmapr(path)
}
\arguments{
\item{path}{path of the R file to plot in Cytoscape}
}
\value{
Cytoscape network visualization
}
\description{
This function allows the user to represent the content of a given script in 'Cytoscape' (<https://cytoscape.org/>).
Therefore it requires to have a functioning version of 'Cytoscape' 3.6.1 or greater.

Each variable is represented as a node and edges represent commands that call the variable.
Functions can also be represented.

A color code is associated to each nodes:

- white: intermediate variables (that are created and used to create new ones),

- pink: subsets of a variable (ex: var2 in var1$var2),

- green: final variables (that are created and not used afterwards),

- red: warnings, message and stop functions,

- yellow: if, else if, else and ifelse functions,

- orange: for, foreach and while functions,

- blue: *print, cat or other functions at beginning of line,

- gray: packages import and session info (wd)

Edge color reports the sequence of command on a blue scale (light: early in the script -to- dark: late in the script)
Node color code extend to edges in case of loops or tests (orange and yellow)

Edges of type sinewave represent the connection between a node and itself when used as an indice.
Edges of type dots represent the commands within a if, else, else if, ifelse or loop condition.

User created functions are represented and pooled as a group, collapsed and extracted to a subnetwork to avoid latency.
}
\examples{
# load example script path
file.path <- system.file("extdata", "example.R", package = "ScriptMapR")

scriptmapr(path=file.path)

}
