% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vectorplot.R
\name{vectorplot}
\alias{vectorplot}
\alias{vectorplot.default}
\alias{vectorplot.loadings}
\alias{vectorplot.Correlation}
\title{Plot vectors inside a unit circle (PCA loadings or correlations plots).}
\usage{
vectorplot(x, ...)

\method{vectorplot}{default}(
  x,
  y,
  col = par("col"),
  circle.col = "gray",
  ar.length = 0.1,
  pos = NULL,
  cex = par("cex"),
  labels = NULL,
  ...
)

\method{vectorplot}{loadings}(
  x,
  choices = 1L:2L,
  col = par("col"),
  circle.col = "gray",
  ar.length = 0.1,
  pos = NULL,
  cex = par("cex"),
  labels = rownames(x),
  main = deparse(substitute(x)),
  ...
)

\method{vectorplot}{Correlation}(
  x,
  choices = 1L:2L,
  col = par("col"),
  circle.col = "gray",
  ar.length = 0.1,
  pos = NULL,
  cex = par("cex"),
  labels = rownames(x),
  main = deparse(substitute(x)),
  ...
)
}
\arguments{
\item{x}{An object that has a [SciViews::vectorplot()] method, like 'loadings'
or 'correlation', or a numeric vector with 0 < values < 1.}

\item{...}{Further arguments passed to plot functions.}

\item{y}{A numeric vector with 0 < values < 1 of same length as `x.}

\item{col}{Color of the arrows and labels.}

\item{circle.col}{The color for the circle around the vector plot.}

\item{ar.length}{The length of the arrows.}

\item{pos}{The position of text relative to arrows. If `NULL`, a suitable
position is calculated according to the direction where the arrows are
pointing.}

\item{cex}{The factor of expansion for labels in the graph.}

\item{labels}{The labels to draw near the arrows.}

\item{choices}{A vector of two integers indicating the axes to plot.}

\item{main}{The title of the plot.}
}
\value{
The object 'x' is returned invisibly. These functions are called for
their side-effect of drawing a vector plot.
}
\description{
Plots vectors with 0 < norms < 1 inside a circle. These plots are mainly
 designed to represent variables in principal components space for PCAs.
}
\examples{
# Create a PCA and plot loadings and correlations
iris.pca <- pcomp(iris[, -5])
vectorplot(loadings(iris.pca))
vectorplot(Correlation(iris.pca))
# Note: on screen devices, change aspect ratio of the graph by resizing
# the window to reveal cropped labels...
}
\seealso{
[SciViews::pcomp()], [stats::loadings()], [SciViews::Correlation()]
}
\concept{Vector and circular plot}
\keyword{aplot}
