# Package Submission Checklist

## Pre-submission Checks

### For All Platforms

- [ ] `R CMD build SVG` succeeds without errors
- [ ] `R CMD check SVG_*.tar.gz --as-cran` returns 0 errors, 0 warnings, 0 notes
- [ ] All tests pass: `devtools::test()`
- [ ] Documentation is up-to-date: `devtools::document()`
- [ ] Package can be installed: `devtools::install()`
- [ ] Vignette builds without errors: `devtools::build_vignettes()`
- [ ] Examples run without errors: `devtools::run_examples()`

---

## CRAN Submission

### Requirements

- [ ] Use DESCRIPTION file (not DESCRIPTION.bioc)
- [ ] Remove `biocViews` field from DESCRIPTION
- [ ] Update `Date` field to current date
- [ ] Ensure all URLs are valid and accessible
- [ ] Check spelling in DESCRIPTION and documentation
- [ ] Verify LICENSE file format

### Pre-flight Checks

```r
# Run these before submission
devtools::check(cran = TRUE)
devtools::spell_check()
urlchecker::url_check()
```

### Submission Process

1. Build source package: `R CMD build .`
2. Check package: `R CMD check SVG_*.tar.gz --as-cran`
3. Submit via: https://cran.r-project.org/submit.html

---

## Bioconductor Submission

### Requirements

- [ ] Copy DESCRIPTION.bioc to DESCRIPTION
- [ ] Version must be 0.99.x for new packages
- [ ] R dependency: R >= 4.4.0 (current Bioc release)
- [ ] Add `biocViews` field with appropriate terms
- [ ] Move Bioconductor packages from Suggests to Imports

### Code Style

- [ ] Line length <= 80 characters
- [ ] Use `BiocParallel` instead of `parallel::mclapply`
- [ ] Consider camelCase function naming
- [ ] No `library()` or `require()` calls in code

### Bioc-specific Checks

```r
# Install BiocCheck
if (!require("BiocManager")) install.packages("BiocManager")
BiocManager::install("BiocCheck")

# Run BiocCheck
BiocCheck::BiocCheck(".")
```

### Submission Process

1. Create new GitHub issue at: https://github.com/Bioconductor/Contributions/issues/new
2. Fill out the template with package information
3. Wait for automated checks and reviewer assignment

---

## rOpenSci Universe

### Requirements

- [ ] Package is already on CRAN or ready for CRAN
- [ ] Comprehensive test coverage (>75%)
- [ ] Well-documented functions with examples
- [ ] Contributing guidelines (CONTRIBUTING.md)
- [ ] Code of Conduct (CODE_OF_CONDUCT.md)

### Pre-submission

1. Read the guide: https://devguide.ropensci.org/
2. Use `pkgcheck`: `pkgcheck::pkgcheck(".")`
3. Ensure GitHub Actions CI is configured

### Submission Process

1. Open issue at: https://github.com/ropensci/software-review/issues/new
2. Use the submission template
3. Wait for editor assignment and review

---

## Quick Commands

```r
# Full check suite
devtools::check()
devtools::test()
devtools::run_examples()
devtools::build_vignettes()

# CRAN-specific
devtools::check(cran = TRUE)
devtools::check_win_devel()
devtools::check_rhub()

# Bioconductor-specific
BiocCheck::BiocCheck(".")

# rOpenSci
pkgcheck::pkgcheck(".")
```

---

## Contact

- CRAN: cran-submissions@r-project.org
- Bioconductor: https://support.bioconductor.org/
- rOpenSci: https://ropensci.org/contact/
