#' Compute Dynamic Gaussian Copula Correlation Parameter (rho)
#'
#' Computes the time-varying correlation parameter (rho) for a Gaussian copula.
#'
#' @param params Numeric vector of parameters: omega, alpha, and gamma coefficients.
#' @param lagged_rho Numeric, the previous rho value.
#' @param X_t Numeric vector or matrix of covariates at time t.
#' @return Numeric, estimated dynamic Gaussian copula correlation.
#' @export
dynamic.rho <- function(params, lagged_rho, X_t) {
  omega <- params[1]
  alpha <- params[2]
  gamma <- params[3:length(params)]
  rho_t <- tanh(omega + alpha * lagged_rho + sum(gamma * X_t))
  return(rho_t)
}
