% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causal_decompose.R
\name{causal_decompose}
\alias{causal_decompose}
\title{Estimation and decomposition of simultaneous equation model}
\usage{
causal_decompose(data, eq.system, resid.est = "noDfCor", instruments,
  sigma.in = NULL)
}
\arguments{
\item{data}{the data frame containing the data}

\item{eq.system}{the system of equations (a list of formula objects, e.g. as in pkg \code{systemfit})}

\item{resid.est}{the estimation methods for the residual covariance matrix (as in \code{systemfit})}

\item{instruments}{the intruments used to estimate the model via 3-SLS (as in \code{systemfit})}

\item{sigma.in}{the \eqn{\Sigma} matrix, if the user wants to simulate a particular structure at stochastic level.
Overrides 3SLS estimation if specified.}
}
\value{
A list with components \itemize{
\item \code{eq.system}: the system of equations given as input
\item \code{Gamma}: the 3-SLS estimate of \eqn{\Gamma'}
\item \code{C}: the matrix highlighting the interdependent mechanisms at deterministic level.
\item \code{Psi1}: the matrix highlighting the interdependent mechanisms at stochastic level.
\item \code{Psi0}: the matrix highlighting the causal mechanisms.
\item \code{A}: the 3-SLS estimate of \eqn{A}
\item \code{Sigma}: the 3-SLS estimate of \eqn{Sigma}
\item \code{systemfit}: the output from the \code{systemfit} function used to
estimate the model
\item \code{all.graph}: the path diagram of the model, using the package \code{igraph}
\item \code{dec.graph}: the path diagram of the decomposed model, with color
coding for each vertex
\item \code{type.out}: the type of analysis performed, either 'simulation' or 'empirical'}
}
\description{
Estimate and/or decompose
a Simultaneous Equation Model into its recursive
and Interdependent sub-systems
}
\examples{
data("macroIT")
eq.system = list(
               eq1 = C ~  CP  + I + CP_1,
               eq2 = I ~ K + CP_1,
               eq3 = WP ~ I + GDP + GDP_1,
               eq4 = GDP ~ C + I + GDP_1,
               eq5 = CP ~ WP + T,
               eq6 = K ~ I + K_1)

instruments = ~ T + CP_1 + GDP_1 + K_1

causal_decompose(data = macroIT,
               eq.system = eq.system,
               resid.est = "noDfCor",
               instruments = instruments,
               sigma.in = NULL)
}
