% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{coef.sgp}
\alias{coef.sgp}
\title{Coefficients from an SGP model}
\usage{
\method{coef}{sgp}(object, lambda, index = 1:length(object$lambda), drop = TRUE, ...)
}
\arguments{
\item{object}{A object that was generated with sgp.}

\item{lambda}{The value of lambda at which the coefficients are to be extracted.}

\item{index}{The index that indicates the lambda at which the coefficients are to be extracted (alternative to specifying 'lambda').}

\item{drop}{A Boolean value that specifies whether empty dimensions should be removed.}

\item{\dots}{Other parameters of underlying basic functions.}
}
\value{
A vector or matrix with the estimated coefficients.
}
\description{
A function that extracts the estimated coefficients from an SGP object.
}
\examples{
n <- 100
p <- 12
nr <- 4
g <- paste0("Group ",ceiling(1:p / nr))
X <- matrix(rnorm(n * p), n, p)
b <- c(-3:3)
y_lin <- X[, 1:length(b)] \%*\% b + 5 * rnorm(n)
y_log <- rbinom(n, 1, exp(y_lin) / (1 + exp(y_lin)))

lin_fit <- sgp(X, y_lin, g, type = "linear")
coef(lin_fit, index = 5:7)

log_fit <- sgp(X, y_log, g, type = "logit")
coef(log_fit, index = 5:7)

}
