% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OIAOCDs.R
\name{OIAOCDs}
\alias{OIAOCDs}
\title{Orthogonal Integer Array Method for Optimal Covariate Designs (OCDs)}
\usage{
OIAOCDs(design)
}
\arguments{
\item{design}{Input a design in matrix format and block size k such that it is an odd number.}
}
\value{
Generates W matrices and Inter product sums of W matrices.
}
\description{
Consider OIA of order same as the block size of the required design. Superimpose each array separately into the incidence matrix (N) to get the W matrices. The maximum number of W matrices depends on the column order of OIA.
}
\examples{
library(SFOCDs)
mat<-matrix(c(1,2,3,1,2,4,1,2,5,1,3,4,1,3,5,1,4,5,2,3,4,2,3,5,2,4,5,3,4,5),nrow=10,byrow=TRUE)
OIAOCDs(mat)
}
\references{
Das, K., N. K. Mandal, and B. K. Sinha. (2003) <https://doi.org/10.1016/S0378-3758(02)00151-9>. Optimal experimental designs for models with covariates. Journal of Statistical Planning and Inference 115(1): 273-285.

Bansal, N., and D. K. Garg. (2022)<https://doi.org/10.1007/s42519-022-00244-0>. Optimum covariate designs for three associate PBIB designs. Journal of Statistical Theory and Practice 16(3): 1-15.
}
\author{
Neethu RS

Cini Varghese

Mohd Harun

Anindita Datta

Ashutosh Dalal
}
