% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{predict_tree}
\alias{predict_tree}
\title{Predict SFHNV tree point estimates}
\usage{
predict_tree(tree, observations)
}
\arguments{
\item{tree}{An object produced by \code{\link[=NW_Tree]{NW_Tree()}}.}

\item{observations}{Data frame of new observations containing the same features
as the training data.}
}
\value{
Numeric vector of predicted structural parameters.
}
\description{
Predict SFHNV tree point estimates
}
\examples{
data <- data.frame(x = rnorm(50), D = rnorm(50), Q = rnorm(50))
tree <- NW_Tree(data, min_size = 10, max_depth = 3)
predict_tree(tree, data)
}
