% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEPaLS.R
\name{SEPaLS}
\alias{SEPaLS}
\title{Function to estimate SEPaLS estimators}
\usage{
SEPaLS(
  X,
  Y,
  yn,
  type = c("vMF", "Laplace"),
  mu0 = NULL,
  kappa0 = NULL,
  lambda = NULL
)
}
\arguments{
\item{X}{\eqn{(n\times p)}-dimensional matrix of the covariates.}

\item{Y}{\eqn{(n)}-dimensional vector of the response.}

\item{yn}{\eqn{y_n} the quantile correponding to lowest values of \eqn{Y}s to put in th
e tail.}

\item{type}{character, wether \code{vMF} for von Mises-Fisher prior or
\code{Laplace} for Laplace prior. See details.}

\item{mu0}{\eqn{\mu_0}, unitary \eqn{(p)}-dimensional vector. The direction
parameter for the \code{vMF} prior.}

\item{kappa0}{\eqn{\kappa_0}, positive. The concentration parameter for the
\code{vMF} prior.}

\item{lambda}{\eqn{\lambda}, positive. The concentration parameter for the
\code{Laplace} prior.}
}
\value{
A SEPaLS estimator
}
\description{
Function to estimate SEPaLS estimators
}
\details{
The SEPaLS estimators are built depending on the value given to
\code{type}:
\itemize{
    \item \code{vMF}: then the estimator is proportional to
    \deqn{ \hat{\beta}_{ml}(y_n) + \kappa_0\mu_0, }
    where \eqn{\hat{\beta}_{ml}(y_n)} is the EPLS estimator, which coincides
    with the maximum-likelihood estimator of SEPaLS for a threshold \eqn{y_n}.
    \item \code{Laplace}: then the estimator is proportional to
    \deqn{ S_\lambda\left(\hat{\beta}_{ml}(y_n)\right), }
    where \eqn{S_\lambda} is the soft-thresholding operator of threshold
    \eqn{\lambda}.
}
}
\examples{
set.seed(1)
n <- 3000
p <- 10
X <- matrix(rnorm(n*p),n,p)
beta <- c(5:1,rep(0,p-5)) ; beta <- beta/sqrt(sum(beta^2))
Y <- (X\%*\%beta)^3 + rnorm(n,sd=1/3)
mu0 <- rnorm(p) ; mu0 <- mu0/sqrt(sum(mu0^2))
sepals_vMF <- SEPaLS(X,Y,yn=1,type="vMF",mu0=mu0,kappa0=1)
sepals_Laplace <- SEPaLS(X,Y,yn=1,type="Laplace",lambda=0.01)
}
\seealso{
\code{\link{bootstrap.SEPaLS}}
}
