#' sp500 data
#'
#' 
#' Companies in the S&P 500 Stock Market Index as of September 15, 2020.
#'Downloaded from \href{https://fknol.com/list/market-cap-sp-500-index-companies.php?go=g0}{https://fknol.com/list/market-cap-sp-500-index-companies.php?go=g0} on September 19, 2020.
#'
#' @format This data frame contains the following columns:
#' 
#' \describe{
#' \item{Company:}{company name (character variable, length 37)}
#' 
#'\item{Symbol:}{stock symbol (character variable, length 5)}
#' 
#' \item{MarketCap:}{market capitalization, in billions of U.S. dollars}
#' 
#' \item{StockPrice:}{price per share of stock}
#' 
#' \item{PE_Ratio:}{price-to-earnings ratio}
#' 
#' \item{EPS:}{earnings per share}
#' }
#'  
#'  
#'  
#'
#' @docType data
#'
#' @usage data(sp500)
#'
#'
#'
#' @keywords datasets
#'
#' @references Lohr (2021), Sampling: Design and Analysis, 3rd Edition. Boca Raton, FL: CRC Press.
#' 
#'@references Lu and Lohr (2021), R Companion for \emph{Sampling: Design and Analysis, 3rd Edition}, 1st Edition. Boca Raton, FL: CRC Press.
#' 
#'
#' 
#' 
#' 
"sp500"

