% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression_outcome_scb.R
\name{fill_missing_with_reference}
\alias{fill_missing_with_reference}
\title{Fill missing variables in grid_df with reference values from df_fit}
\usage{
fill_missing_with_reference(df_fit, grid_df, model_vars = NULL)
}
\arguments{
\item{df_fit}{A data frame used for model fitting. Character columns will be
coerced to factors before alignment.}

\item{grid_df}{A data frame of covariate settings (newdata) at which
predictions/SCBs are to be evaluated.}

\item{model_vars}{A vector contained all the interested columns that appear
in \code{df_fit}. Only those variables are aligned in \code{grid_df};
other columns are left unchanged. Default is NULL.}
}
\value{
grid_df with missing columns filled:
\itemize{
\item factor/ordered: reference = first level in df_fit
\item character: coerced to factor, reference = first unique value
\item numeric/integer: reference = numeric_ref (default 0)
}
}
\description{
Fill missing variables in grid_df with reference values from df_fit
}
\examples{
# Used internally by SCB_linear_outcome, SCB_logistic_outcome

}
\keyword{internal}
