% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.safe.R
\name{eccv.safe}
\alias{eccv.safe}
\title{Cross-validation for selecting the tuning parameter of the SAFE model}
\usage{
eccv.safe(x, y, k, lambda, ind_p, rep = 24, nfolds = 5L, ...)
}
\arguments{
\item{x}{A numeric matrix of dimensions \eqn{n \times p}, where \eqn{n} is the number of observations
and \eqn{p} is the number of predictors.}

\item{y}{A numeric vector of length \eqn{n}, representing the loss values (severity). These are assumed
to follow a Gamma distribution with shape parameter \code{alpha} and scale parameter
\eqn{\theta = \exp(x^\top \gamma) / \alpha}.}

\item{k}{A numeric vector of length \eqn{n}, representing the number of claims (frequency), assumed to follow
a Poisson distribution with mean \eqn{\mu = x^\top \beta}.}

\item{lambda}{A user-supplied numeric vector of tuning parameters. The function will compute the solution
for each value in \code{lambda}.}

\item{ind_p}{A user-provided index or indicator specifying which predictors should share the same sign
across frequency and severity.}

\item{rep}{The number of repeated cross-validation cycles (default is 24). In each cycle, observations
are randomly assigned to \code{nfolds} folds, cross-validation is performed for all \code{lambda}
values, and a "vote" is cast for the \code{lambda} with the lowest error in that cycle.}

\item{nfolds}{The number of folds in cross-validation. Default is 5.}

\item{...}{Additional arguments passed to \code{\link{safe}}.}
}
\value{
An object of class \code{"safe"}, which is a list containing:
\item{\code{lambda.min}}{The tuning parameter \code{lambda} value that won the most votes (i.e.,
     achieved the minimum cross-validation error most often).}
\item{\code{lambda}}{The full sequence of candidate \code{lambda} values provided to the function.}
\item{\code{ncvmat}}{A numeric matrix of dimension \code{rep} * the length of \code{lambda},
      containing the cross-validation errors for each \code{lambda} across all \code{rep} runs.}
}
\description{
Performs "electoral college" cross-validation for the \code{\link{safe}} function. Unlike a standard
cross-validation approach, this method repeats the random partitioning into folds multiple times
(controlled by \code{rep}), then selects the tuning parameter \code{lambda} via a majority vote
across these repeated cross-validation runs.
This function is largely similar [glmnet::cv.glmnet()].
}
\details{
The function computes the average cross-validation error and reports the best \code{lambda} that achieves the 
smallest cross-validation error.
}
\examples{
set.seed(1)
n <- 100
p <- 5
x <- matrix(rnorm(n * p), nrow = n, ncol = p)
beta_true <- rep(0.1, 5)
gamma_true <- c(rep(1, 3), -1, -1)
mu <- x \%*\% beta_true
k <- rpois(n, lambda = exp(mu))
alpha_val <- 1
theta <- exp(x \%*\% gamma_true) / alpha_val
y <- rgamma(n, shape = alpha_val, scale = theta)
lambda_seq <- 10^seq(2, -8, length.out = 5)
fit <- eccv.safe(x, y, k, lambda=lambda_seq, ind_p = c(1, 1, 1, 0, 0))
}
\keyword{cross}
\keyword{validation}
