% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_functions.R
\name{tsEvaNanRunningMean}
\alias{tsEvaNanRunningMean}
\title{Calculate the running mean of a time series with NaN handling}
\usage{
tsEvaNanRunningMean(series, windowSize)
}
\arguments{
\item{series}{The input time series}

\item{windowSize}{The size of the sliding window}
}
\value{
A vector containing the running mean of the time series
}
\description{
This function calculates the running mean of a time series, taking into account NaN values.
It uses a sliding window approach to calculate the mean, where the window size is specified by the user.
If the number of non-NaN values within the window is greater than a threshold, the mean is calculated.
Otherwise, NaN is returned.
}
\examples{
series <- c(1,2,NaN,4,5,6,NaN,8,9,4,5,6,7,3,9,1,0,4,5,2)
windowSize <- 3
result <- tsEvaNanRunningMean(series, windowSize)
print(result)

}
