% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_functions.R
\name{tsEvaChangepts}
\alias{tsEvaChangepts}
\title{Change point detection in time series}
\usage{
tsEvaChangepts(series, timeWindow, timeStamps)
}
\arguments{
\item{series}{A numeric vector representing the time series.}

\item{timeWindow}{An integer specifying the minimum length of segments.}

\item{timeStamps}{A vector of timestamps corresponding to the series data points.}
}
\value{
A list containing:
\describe{
\item{\code{trend}}{A numeric vector of the same length as series, with each segment between change points filled with its mean value}
\item{\code{variance}}{A numeric vector of the same length as series, with each segment between change points filled with its variance}
\item{\code{changepoints}}{A vector of timestamps at which change points were detected}
}
}
\description{
This function applies the PELT method for change point detection in a time series.
It returns the mean and variance of the series segments between change points.
}
\examples{
\donttest{
timeAndSeries <- ArdecheStMartin
timeStamps <- ArdecheStMartin[,1]
series <- ArdecheStMartin[,2]
timeWindow <- 30*365 # 30 years
result <- tsEvaChangepts(series, timeWindow, timeStamps)
plot(timeAndSeries, type = "l")
lines(timeStamps,result$trend,col=2)
points(timeStamps[result$changepoints], result$trend[result$changepoints], col = "red")
}
}
