% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tropsvm_helper.R
\name{tropsvm_helper}
\alias{tropsvm_helper}
\title{Helper for \code{cv.tropsvm}}
\usage{
tropsvm_helper(x, y, assignment = NULL, ind = 1, newx = NULL, newy = NULL)
}
\arguments{
\item{x}{a data matrix, of dimension nobs x nvars; each row is an observation vector.}

\item{y}{a response vector with one label for each row/component of x.}

\item{assignment}{a numeric vector of length 4 indicating the sectors of tropical hyperplane that the
data will be assigned to. The first and third elements in the \code{assignment} are the coordinates of
an observed point in data matrix \code{x} believed from the first category where the maximum and second maximum
of the vector addition between the fitted optimal tropical hyperplane and the point itself are achieved.
The meanings for the second and the fourth element in the \code{assignment} are the same
but for the points in the second category. Namely, the first and second values in the \code{assignment}
are the indices of sectors where the two point cloud will be assigned. Not needed when \code{auto.assignment = TRUE}. (default: NULL)}

\item{ind}{a numeric value or a numeric vector ranging from 1 to 70 indicating which classification method
to be used. There are 70 different classification methods. Details of a given method can be retrieved by \code{summary}.
 The different classification methods are proposed to resolve the issue when points fall on the intersections of sectors.
 Users can have personal choices if better knowledge is assumed. (default: 1)}

\item{newx}{the same as "x" but only needed in \code{cv.tropsvm}, which is used as validation data. (default: \code{NULL})}

\item{newy}{the same as "y" but only needed in \code{cv.tropsvm}, which is used as validation labels (default: \code{NULL})}
}
\value{
Classification accuracy
}
\description{
Helper for \code{cv.tropsvm}
}
\keyword{Compute}
\keyword{a}
\keyword{accuracy}
\keyword{and}
\keyword{assignment}
\keyword{classification}
\keyword{cross}
\keyword{for}
\keyword{in}
\keyword{internal}
\keyword{method}
\keyword{of}
\keyword{pair}
\keyword{validation}
