% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/troppca.poly.R
\name{troppca.poly}
\alias{troppca.poly}
\title{Tropical Principal Component Analysis by Tropical Polytope}
\usage{
troppca.poly(x, pcs = 2, nsample = 1000, ncores = 2)
}
\arguments{
\item{x}{a data matrix, of size n x e, with each row an observation vector.
e is the dimension of the tropical space#'}

\item{pcs}{a numeric value indicating the order of principal component. (default: 2)}

\item{nsample}{a numeric value indicating the number of samples of MCMC. (default: 1000)}

\item{ncores}{a numeric value indicating the number of threads utilized for multi-cored CPUs. (default: 2)}
}
\value{
A list of S3 class \code{"troppca"}, including:
\item{pc}{The principal component as a tropical linear space}
\item{obj}{The tropical PCA objective, the sum of tropical distance from each point to the projection.}
\item{projection}{The projections of all data points.}
\item{type}{The geometry of principal component.}
}
\description{
Approximates the principal component as a tropical polytope for a given data matrix
via MCMC and return the results as an object of class \code{troppca}.
}
\examples{
\donttest{
library(Rfast)
n <- 50
e <- 50
s <- 5
x <- rbind(
  rmvnorm(n, mu = c(5, -5, rep(0, e - 2)), sigma = diag(s, e)),
  rmvnorm(n, mu = c(-5, 5, rep(0, e - 2)), sigma = diag(s, e))
)
troppca_fit <- troppca.poly(x)
plot(troppca_fit)
}

}
