% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPC.R
\name{Rule7}
\alias{Rule7}
\title{Rule 7}
\usage{
Rule7(x, nPoints = 15, zoneB, ...)
}
\arguments{
\item{x}{Numerical vector}

\item{nPoints}{Sequence of consequtive points to be evaluated}

\item{zoneB}{Vector of zone borders}

\item{...}{unspecified arguments of a function}
}
\value{
Vector of the same length as x
}
\description{
Fifteen points in a row are all within 1 standard deviation of the mean on either side of the mean.
}
\details{
0 means: ok \cr
1 means: violation \cr

equality used during evaluation
}
\examples{
limits = CalculateLimits(x = rnorm(10), lcl = NA, cl = 100, ucl = NA, type = 'i')
zones = CalculateZoneBorders(limits)
Rule7(x = rnorm(20), zoneB = zones, nPoints = 15)
#zones is object created by function CalculateZoneBorders()
}
